#include "GBA.h"
#include<windows.h>
#include<stdio.h>
#include "port.h"
#include "Link.h"

#define UPDATE_REG(address, value) WRITE16LE(((u16 *)&ioMem[address]),value)
#define LINK_ID1FINISH 2
#define LINK_ID2FINISH 4

unsigned int linktime = 0;
u8 tspeed=3;
u8 transfer=0;
LINKDATA *linkmem=NULL;
int linkid = 1;
extern HANDLE linksync[4];
extern int *extTicks;
unsigned int savedlinktime=0;
#ifdef LINKLOG
	FILE *jjj;
#endif

unsigned int trspeed1[4] = {34080, 8520, 5680, 2840};
unsigned int trspeed2[4] = {65536, 16384, 10923, 5461};
unsigned int trspeed2_5[4] = {72527, 18132, 12088, 6044};
unsigned int trspeed3[4] = {99609, 24903, 16602, 8301};
unsigned int trspeed3_5[4] = {106608, 26652, 17768, 8884};
unsigned int trspeed4[4] = {133692, 33423, 22282, 11141};

void StartLink(WORD value){
	switch(value & 0x3000){
		case 0x2000:
		if(value & 0x80){
			if(!linkid){  
				if(!transfer&&linkmem->numgbas>1){
					linkmem->linkflags &= !(LINK_ID1FINISH | LINK_ID2FINISH);
					ResetEvent(linksync[0]);
					linkmem->linkcmd[0] = value;
					transfer = 1;
					if(linkmem->numtransfers!=0)
						savedlinktime = linktime;
					else
						savedlinktime = 0;
					linktime = 0;
					tspeed = value & 3;
					_asm{
						mov eax, ioMem;
						mov dword ptr [eax+0x120], 0xffffffff;
						mov dword ptr [eax+0x124], 0xffffffff;
					}
				}
			} else {
				value &= 0xff7f;
				value |= (transfer!=0)<<7;
			}
		}
		value &= 0xffbb;
		value |= (linkid ? 0xc : 8);
		UPDATE_REG(0x128, value);
		break;
	}
return;
}

void LinkUpdate(void){
	if(linkid){	
		/* linktime is sometimes negative but I don't know why */
		if(linktime>=0x80000000)
			linktime=0;
	
		savedlinktime = linkmem->lastlinktime;
		if(linkid==1||(linkid==2&&(linkmem->linkflags&LINK_ID1FINISH))||(linkid==3&&(linkmem->linkflags&LINK_ID2FINISH)))
		if(!transfer&&linktime>=savedlinktime&&linkmem->numtransfers){
			
			if(linkid==2)
				linkmem->linkflags &= !LINK_ID1FINISH;
			else if(linkid==3)
				linkmem->linkflags &= !LINK_ID2FINISH;

			if(linkmem->numtransfers!=1)//{
				linktime -= savedlinktime;
			else
				linktime = 0;

			switch((linkmem->linkcmd[0])&0x3000){
				case 0x2000:
				tspeed = (linkmem->linkcmd[0]) & 3;
				transfer = 1;
				_asm{
					mov eax, ioMem;
					mov dword ptr [eax+0x120], 0xffffffff;
					mov dword ptr [eax+0x124], 0xffffffff;
					or byte ptr [eax+0x128], 0x80;
				}
				break;
			}
		}
	}
	
	if(transfer == 1 && linktime >= trspeed1[tspeed]){
		UPDATE_REG(0x120, linkmem->linkdata[0]);
		transfer++;
	}
	
	if(transfer == 2 && linktime >= trspeed2[tspeed]){
		if(!linkid){
			linkmem->numtransfers++;
			if(linkmem->numtransfers==0)
				linkmem->numtransfers=2;
			linkmem->lastlinktime=savedlinktime;
			if(linkmem->numtransfers!=1)
				SetEvent(linksync[1]);
			WaitForSingleObject(linksync[0], 1000);
			ResetEvent(linksync[0]);
#ifdef LINKLOG
			fprintf(jjj, "%04x %04x %04x %04x %10u\n", 
				linkmem->linkdata[0], linkmem->linkdata[1], linkmem->linkdata[2], linkmem->linkdata[3], linkmem->lastlinktime);
#endif
		}
		UPDATE_REG(0x122, linkmem->linkdata[1]);
		transfer++;
	}

	if(transfer == 3 && linktime >= trspeed2_5[tspeed] && linkmem->numgbas==2){
		if(linkid){
			SetEvent(linksync[0]);
			if(WaitForSingleObject(linksync[1], 1000)==WAIT_TIMEOUT){
				linkmem->numtransfers=0;
			} else {
			}
		ResetEvent(linksync[1]);
		}
		transfer = 0;
		linktime -= trspeed2_5[tspeed];
		if((*(u16*)&ioMem[0x128]) & 0x4000){
			IF |= 0x80;
			UPDATE_REG(0x202, IF);
		}
		UPDATE_REG(0x128, (*(u16 *)&ioMem[0x128] & 0xff0f) | (linkid << 4));
		linkmem->linkdata[linkid] = 0xffff;
	}
	
	if(transfer == 3 && linktime >= trspeed3[tspeed]){
		if(linkid==1){
			linkmem->linkflags |= LINK_ID1FINISH;
			if(linkmem->numtransfers!=1)
				SetEvent(linksync[2]);
			WaitForSingleObject(linksync[1], 1000);
			ResetEvent(linksync[1]);
		}
		UPDATE_REG(0x124, linkmem->linkdata[2]);
		transfer++;
	}

	if(transfer == 4 && linktime >= trspeed3_5[tspeed] && linkmem->numgbas==3){
		if(linkid==2){
//			MessageBox(NULL, "jbgn", "fkjdh", MB_OK);
			SetEvent(linksync[0]);
			if(WaitForSingleObject(linksync[2], 1000)==WAIT_TIMEOUT){
				linkmem->numtransfers=0;
			} else {
			}
		ResetEvent(linksync[2]);
		}
		transfer = 0;
		linktime -= trspeed3_5[tspeed];
		if((*(u16*)&ioMem[0x128]) & 0x4000){
			IF |= 0x80;
			UPDATE_REG(0x202, IF);
		}
		UPDATE_REG(0x128, (*(u16 *)&ioMem[0x128] & 0xff0f) | (linkid << 4));
		linkmem->linkdata[linkid] = 0xffff;
	}

	if(transfer == 4 && linktime >= trspeed4[tspeed]){
		if(linkid==2){
			linkmem->linkflags |= LINK_ID2FINISH;
			if(linkmem->numtransfers!=1)
				SetEvent(linksync[3]);
			WaitForSingleObject(linksync[2], 1000);
			ResetEvent(linksync[2]);
		}
		UPDATE_REG(0x126, linkmem->linkdata[3]);
		if(linkid==3){
			SetEvent(linksync[0]);
			if(WaitForSingleObject(linksync[3], 1000)==WAIT_TIMEOUT){
				linkmem->numtransfers=0;
			} else {
			}
		ResetEvent(linksync[3]);
		}
		transfer = 0;
		linktime -= trspeed4[tspeed];
		if((*(u16*)&ioMem[0x128]) & 0x4000){
			IF |= 0x80;
			UPDATE_REG(0x202, IF);
		}
		UPDATE_REG(0x128, (*(u16 *)&ioMem[0x128] & 0xff0f) | (linkid << 4));
		linkmem->linkdata[linkid] = 0xffff;
	}

return;
}

void LinkData(WORD value){
	linkmem->linkdata[linkid] = value;
return;
}